/* 
	Real Time LED Controller, by Mauro Grassi, October 2010.
	
*/

#include "led.h"
#include <math.h>
#include "main.h"
#include "Delay.h"

#pragma udata leddata

volatile unsigned int   ledTimer;
volatile unsigned int   ledDelta;
volatile unsigned char  ledRepeat;
volatile unsigned int   ledOnTime;
volatile unsigned char  ledState;
volatile unsigned int   ledOffTime;
volatile unsigned char  ledDivider;

#pragma code usercode

#if 0
unsigned char immediateLED(unsigned char c)
{
	if(c)
	{
		LED1=LED1_ON;
		LED1_TRIS=0;
	}
	else
	{
 		if(T2CON!=0)
		{
		  LED1=!LED1_ON;
		  LED1_TRIS=0;
		}
		else
		{
		  LED1_TRIS=1;
		  LED1=!LED1_ON;
		}
	}	
}
#endif

unsigned char internalSetLED(unsigned char repeat, unsigned int durationms, unsigned int durationoffms)
{
	/* 
		Turn on LED...
				
	*/
	unsigned int  d;
	unsigned char gsave;
	
	switch(ledState)
	{
		case LED_IDLE_STATE:
			gsave=PIE5bits.TMR6IE;		
			PIE5bits.TMR6IE=0;		
			d=(unsigned int)(0.5+((float)durationms*(float)CONVERT_FACTOR_MS_TO_TICKS));
			if(d>0)ledDelta=d; else if(durationms>0)ledDelta=1; else ledDelta=0;
			if((ledRepeat+(unsigned int)repeat)<0xFF)ledRepeat+=(unsigned int)repeat; else ledRepeat=0xFF;
			d=(unsigned int)(0.5+((float)durationoffms*(float)CONVERT_FACTOR_MS_TO_TICKS));
			if(d>0)ledOffTime=d; else if(durationoffms>0)ledOffTime=1; else ledOffTime=0;
			PIE5bits.TMR6IE=gsave;
			break;

		default:
		case LED_ON_STATE:
		case LED_ON_HOLD_OFF_STATE:		
		case LED_TURN_OFF_STATE:								
		case LED_OFF_HOLD_OFF_STATE:
		case LED_REDO_STATE:
			break;	
	}

	if((PMDIS2bits.TMR6MD==0)&&(T6CON==0)&&(ledState==LED_IDLE_STATE))
	{
		T6CON=0;
		TMR6=0;
		T6CON=T6CON_VALUE;
		PR6=0xFF;
		ledState=LED_ON_STATE;
		IPR5bits.TMR6IP=LED_IP;
		PIR5bits.TMR6IF=0;
		PIE5bits.TMR6IE=1;		
	}
	
}

unsigned char setLED(unsigned int durationms)
{
	return internalSetLED(1, durationms, 0);
}

#if 0
unsigned char getLED(void)
{
	if(LED1==LED1_ON)return 1; else return 0;
}
#endif

void powerLED(unsigned char on)
{	
	if(on)
	{
		#if(USE_PMDIS)
			PMDIS2bits.TMR6MD=0;
		#endif
		T6CON=0;
		LED1=!LED1_ON;
		LED1_TRIS=0;
	}
	else
	{
		LED1=!LED1_ON;
		/* 
		
		The LED will glow very dimly in standby, but this will definitely
		turn off the FET, thus saving power! 
		
		*/
		
		LED1_TRIS=1;
		#if(USE_PMDIS)
			PMDIS2bits.TMR6MD=1;
		#endif
	}
}

void initLED(void)
{
	ledState=LED_IDLE_STATE;
	ledTimer=0;
	ledOnTime=0;
	ledDelta=0;
	ledRepeat=0;
	ledOffTime=0;
	powerLED(1);						
}
